require( "scripts/style.lua" )

-- Start the Comic Screen Timer
StartComicScreenTimer();

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

MakeDialog
{
	Bitmap
	{ 
		image="images/ComicPanel1Sketch2.jpg",	
		x=kCenter,
		y=kCenter,

		-- button to leave comic
		Button{
			x=680,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name = "next",
			type = kPush,
			label = "done",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					-- Pause the timer
					PauseComicScreenTimer();

					PopModal();
					DoModal("scripts/album.lua");
				end
		};
		
		-- How did I get myself...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=57, y=52,
			w=78,h=46,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_a",
		};
		
		-- Hey Quinn! Ready for...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=223, y=216,
			w=75,h=44,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_b",
		};
		
		-- I'm so stressed out...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=320, y=56,
			w=145,h=49,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_c",
		};
		
		-- You're getting married...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=455, y=86,
			w=60,h=40,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_d",
		};
		
		-- I wish...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=528, y=50,
			w=160,h=58,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_e",
		};
		
		-- Did you get a...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=704, y=51,
			w=56,h=75,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_f",
		};
		
		-- Now breathe in...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=705, y=138,
			w=54,h=45,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_m",
		};
		
		-- I have some names...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=83, y=328,
			w=227,h=33,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_g",
		};
		
		-- Calm down...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=72, y=466,
			w=89,h=55,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_h",
		};
		
		-- Breathe out and relax...
		Text
		{
			font = { comicFont, 12, BlackColor };
			x=244, y=481,
			w=64,h=35,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_n",
		};
		
		-- Well, I am pretty good...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=318, y=268,
			w=81,h=55,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_i",
		};
		
		-- That's the spirit!...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=436, y=268,
			w=68,h=49,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_j",
		};
		
		-- CAKE!...
		Text
		{
			font = { comicFont, 13, BlackColor };
			x=510, y=326,
			w=130,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_k",
		};
		
		-- SEE?...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=666, y=324,
			w=100,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_2_l",
		};
	}
}

PlayComicMusic();



